

####################################################################################################
#
#                                           EXTERNAL LIBRARIES
#
####################################################################################################

import os
import sys

####################################################################################################
#
#                                           CLASSES
#
####################################################################################################

class aligned_items:
	"""
	****************************************************************************
	aligned_items is an object composed of various parts:

	it1, it2               : 2 string names or 2 integer IDs
	number_of_blocks       : integer. The number of blocks in correspodance
	blocks_it1, blocks_it2 : a list of 2 integers sub-lists. Each sub-list
	                         gives intial and final sequence positions of
	                         each block in correspondance
	Example:
	    ali = aligned_items('first_item','last_item')
	****************************************************************************
	"""
	def __init__(self,i1,i2):
		"""
		[Init]----------------------------------------------------------------------
		|
		|   Creates a new aligned_items.
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   aligned_items( i1 , i2 ) whre i1 and i2 stands for items names
		|
		[Returned values]-----------------------------------------------------------
		|
		|   aligned_items object
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		|
		|---------------------------------------------------------------------------
		"""
		self.it1			  = i1
		self.it2			  = i2
		self.number_of_blocks = 0
		self.blocks_it1		  = []
		self.blocks_it2		  = []
		self.marked_incident  = 0
	
	def add_blocks(self,bl1,bl2):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Add in place blocks in one-to-one correpondance.
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   bl1 : a list of 2 integers: the sequence position of the start and end
		|         of the block
		|   bl2 : a list of 2 integers: the sequence position of the start and end
		|         of the block
		|
		[Returned values]-----------------------------------------------------------
		|
		|   noting. aligned_items object modified in place
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.add_blocks([2,10],[23,31])
		|
		|---------------------------------------------------------------------------
		"""
		self.blocks_it1.append(bl1)
		self.blocks_it2.append(bl2)
		self.number_of_blocks += 1
	
	def align_length(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Returns the cummulative length of aligned blocks in a aligned_items object
		|   checking length are equal on it1 and it2 blocks
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   an integer
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.add_blocks([2,10],[23,31])
		| >>> ali.align_length()
		| 9
		|
		|---------------------------------------------------------------------------
		"""
		l_qu = 0
		for l in map(lambda u: u[1]-u[0]+1,self.blocks_it1):
			l_qu += l
		l_db = 0
		for l in map(lambda u: u[1]-u[0]+1,self.blocks_it2):
			l_db += l
		if l_qu == l_db :
			return l_qu
		else:
			return 0
	
	def name(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Return the concatanated name of the Yakusa alignment with the following
		|   format:  it1_name+'_'+it2_name
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   string: string
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.name()
		|
		|---------------------------------------------------------------------------
		"""
		return str(self.it1)+'_'+str(self.it2)
	
	def name_info(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Display the name of the items.
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   none
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.name_info()
		|
		|---------------------------------------------------------------------------
		"""
		sys.stdout.write('#########################################\n')
		sys.stdout.write('|  Item 1 : %s  | Item 2 : %s\n'%(self.it1,self.it2))
	
	def it1_info(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Display informations stored on the it1
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   none
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.it1_info()
		|
		|---------------------------------------------------------------------------
		"""
		sys.stdout.write('------------------------------------------\n')
		sys.stdout.write('|     Item 1  : %s\n'%(self.it1))
		if self.number_of_blocks > 0 :
			sys.stdout.write('|\n')
			sys.stdout.write('|     Aligned blocks : %15s\n'%(str(self.blocks_it1[0])))
			for i in self.blocks_it1[1:]:
				sys.stdout.write('|                      %15s\n'%(str(i)))
	
	def it2_info(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Display informations stored on the it2
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   none
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.it2_info()
		|
		|---------------------------------------------------------------------------
		"""
		sys.stdout.write('-----------------------------------------\n')
		sys.stdout.write('|     Item 2  : %s\n'%(self.it2))
		if self.number_of_blocks > 0 :
			sys.stdout.write('|\n')
			sys.stdout.write('|     Aligned blocks : %15s\n'%(str(self.blocks_it2[0])))
			for i in self.blocks_it2[1:]:
				sys.stdout.write('|                      %15s\n'%(str(i)))
	
	def info(self):
		"""
		[Goal]----------------------------------------------------------------------
		|
		|   Display informations of an aligned_items
		|
		[Arguments]-----------------------------------------------------------------
		|
		|   none
		|
		[Returned values]-----------------------------------------------------------
		|
		|   none
		|
		[Example]-------------------------------------------------------------------
		|
		| >>> ali = aligned_items('first_item','last_item')
		| >>> ali.hit_info()
		|
		|---------------------------------------------------------------------------
		"""
		self.name_info()
		self.it1_info()
		self.it2_info()
