#!/usr/bin/python

from yakalign import *
from os       import listdir

dirYakusaOut = '/Users/santini/irix/Cluster50_PairGraph/YakAlign/'


#-----------------------------------------------
# Dictionnaire des alignements
d_ALIGN = {}
#-----------------------------------------------
# Dictionnaire PDB -> ID et ID -> PDB
d_PDB_to_ID = {}
d_ID_to_PDB = {}
ID = 0


#-----------------------------------------------
# lecture des donnees d'laignement
inputfiles = []
for filename in listdir(dirYakusaOut) :
	if ( filename[-4:] == '.out' ) and ( len(filename) == 10 ) : 
		inputfiles.append(dirYakusaOut+filename)



for file in inputfiles :
# file = inputfiles[0]
	for ya in read_all_yakusa_pair_data( file ) :
		# ya = read_all_yakusa_pair_data( file )[0]
		# Actualisation du dico des noms
		if ya.query != ya.dbase :
			if not d_PDB_to_ID.has_key( ya.query ) :
				d_PDB_to_ID[ ya.query ] = ID
				d_ID_to_PDB[ID]         = ya.query
				ID += 1
			
			if not d_PDB_to_ID.has_key( ya.dbase ) :
				d_PDB_to_ID[ ya.dbase ] = ID
				d_ID_to_PDB[ID]         = ya.dbase
				ID += 1
			
			ya.query = d_PDB_to_ID[ ya.query ]
			ya.dbase = d_PDB_to_ID[ ya.dbase ]
			
			if ya.zscore > 7.0 :
				p1 = min( ya.query , ya.dbase )
				p2 = max( ya.query , ya.dbase )
				if not d_ALIGN.has_key((p1,p2)):
					d_ALIGN[(p1,p2)] = ya
				else :
					if ya.align_length() > d_ALIGN[(p1,p2)].align_length() :
						d_ALIGN[(p1,p2)] = ya


fod = open('/Users/santini/cvswork/LineGraph/data/yak_clu50_7.0','w')
# Ecriture du fichier de similarites
for ya in d_ALIGN.values() :
	for bl_nb in range( 0 , len( ya.query_blocks ) ) :
		fod.write( '%20s\t%6d\t%6d\t%20s\t%6d\t%6d\n'%( d_ID_to_PDB[ya.query]      , \
		                                             ya.query_blocks[bl_nb][0]  , \
		                                             ya.query_blocks[bl_nb][1]  , \
		                                             d_ID_to_PDB[ya.dbase]      , \
		                                             ya.dbase_blocks[bl_nb][0]  , \
		                                             ya.dbase_blocks[bl_nb][1]  ) )


fod.close()