#!/bin/bash


DIR_CORON=${DIR_PROJCLOS}/coron-0.8

function set_prog
{
VERSION_ABSTRACTION=$1
if [[ $VERSION_ABSTRACTION == "Global" ]] ; then
        PROG_ABS=$DIR_PROJCLOS/abstraction.py
       # LOC="g"
else
        PROG_ABS=$DIR_PROJCLOS/abstraction_locale.py
        #LOC="l"
fi
}

# collecting parameters

DIR_DATA=$PWD/`dirname $1`
NOM=`basename $1 .ri`
PROG_VERSION=$2
CORON_MIN_SUP=$3
ABSTRACT_MIN_SUP=0
MIN_DEG=$4
MIN_CC=$5
MIN_TER_CC=$6
OUT_PATH=$7


set_prog ${PROG_VERSION}


echo "-------------------------------------------------------------"
echo "- Formating CORON input file from *.ri file"
echo "- extract_rcf_form_ri.py"
${DIR_PROJCLOS}/extract_rcf_from_ri.py 	${DIR_DATA}/${NOM}.ri ${DIR_DATA}/${NOM}.rcf

echo "-------------------------------------------------------------"
echo "- executing CORON frequent closed pattern mining"
echo "- CORON core01_coron.sh"
cd ${DIR_CORON}
./core01_coron.sh						${DIR_DATA}/${NOM}.rcf ${CORON_MIN_SUP} \
										-names -alg:dtouch | sed '1 s/rcf$/ri/' > \
										${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.coron.fcige

# the next step fix the fact that CORON do not consider the empty set pattern in its outputs
# the following script add the empty set rule {} (N) ; {{}} if the empty do not appear as
# a generator in the outputs of CORON
${DIR_PROJCLOS}/check_add_bottom.py		${DIR_DATA}/${NOM}.ri \
										${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.coron.fcige \
										${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.fcige
cd ${DIR_DATA}

echo "-------------------------------------------------------------"
echo " abstraction_local.py"
${PROG_ABS}		${ABSTRACT_MIN_SUP} ${MIN_DEG} ${MIN_CC} ${MIN_TER_CC} \
				${DIR_DATA}/${NOM}.ri \
				${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.fcige \
				${OUT_PATH}


# Cleaning intermediate file
rm	${DIR_DATA}/${NOM}.rcf \
	${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.coron.fcige \
	${DIR_DATA}/${NOM}_${CORON_MIN_SUP}.fcige

