#!/usr/bin/python
# -*- coding: utf8 -*-

from RIParser import RIParser
import sys
import os


def usage() :
	print "\
----------------------------------------------------------- \n\
           Extraction d'un fichier *.rcf pour coron         \n\
		   a partir d'un fichier *.ri                       \n\
                                                            \n\
Ce script permet de generer un fichier *.rcf pour Coron a   \n\
partir d'un fichier *.ri.                                   \n\
Le script admet en parametre 2 nom (chemin de fichier)      \n\
    [-] le fichier ri ou sont lues les donnees              \n\
    [-] le fichier rcf ou sont ecrites les donnees          \n\
Les fichiers doivent imeprativement avoir les bonnes        \n\
extensions.                                                 \n\
                                                            \n\
----------------------------------------------------------- "


if __name__ == "__main__" :
	#------------------
	# le programme prend un parametre: le nom du fichier *.ri dont il faut ajuster
	# l'ordre des attributs
	if len(sys.argv) != 3 :
		sys.stderr.write("Erreur: il manque un ou plusieurs arguments.\n")
		usage()
		sys.exit(1)
	#------------------
	RI_IN  = sys.argv[1]
	RCF_OUT = sys.argv[2]
	#------------------
	# le premeir paramètre est le chemin de lecture du fichier .ri d'entree
	if not( len(RI_IN) > 3 and RI_IN[-3:]==".ri" and os.access(RI_IN,os.F_OK) and os.access(RI_IN,os.R_OK)) :
		sys.stderr.write("Erreur: chemin vers fichier .ri en lecture : "+RI_IN+ " incorrect.\n"        )
		sys.exit(1)
	#------------------
	# le dernier paramètre est le chemin d'ecriture du fichier .ri de sortie
	if not( len(RCF_OUT) > 4 and RCF_OUT[-4:]==".rcf" and (not os.access(RCF_OUT,os.F_OK) or os.access(RCF_OUT,os.W_OK ) ) ) :
		sys.stderr.write("Erreur: chemin vers fichier .rcf en écriture : "+RCF_OUT+ " incorrect.\n"        )
		usage()
		sys.exit(1)
	#------------------
	# lecture des données du fichier
	fi = open( RI_IN, 'r')
	parser = RIParser( fi)
	ri = parser.parse()
	fi.close()
	#------------------
	# ecriture des données 
	fo = open( RCF_OUT, 'w')
	fo.write(ri.str_rcf())
	fo.close()
	exit(0)
	
	





