#!/usr/bin/python
# -*- coding: utf8 -*-

from RIParser import RIParser
from FCIGEParser import FCIGEParser
from Itemset import Itemset
import sys
import os


def usage() :
	print "\
----------------------------------------------------------- \n\
                Ajustement des fichiers *.fcige             \n\
                                                            \n\
Ce script permet de vérifier la présence du motif vide dans \n\
la liste des regles du fichier. Si elle est presente le     \n\
script ne fait rien. Si elle est absente le script rajoute  \n\
la regle:                                                   \n\
           {} (sup_max) ; [{}]                              \n\
avec sup_max le nombre d'objet trouvés dans le fichier ri   \n\
passé en parametre.                                         \n\
                                                            \n\
Syntaxe:                                                    \n\
                                                            \n\
    ./check_add_bottom.py in.ri in.fcige out.fcige          \n\
                                                            \n\
----------------------------------------------------------- "


if __name__ == "__main__" :
	#------------------
	# le programme prend un parametre: le nom du fichier *.ri dont il faut ajuster
	# l'ordre des attributs
	if len(sys.argv) != 4 :
		sys.stderr.write("Erreur: il manque un ou plusieurs arguments.\n")
		usage()
		sys.exit(1)
	#------------------
	RI_IN  = sys.argv[1]
	FCIGE_IN = sys.argv[2]
	FCIGE_OUT = sys.argv[3]
	#------------------
	# le premier paramètre est le chemin de lecture du fichier .ri d'entree
	if not( len(RI_IN) > 3 and RI_IN[-3:]==".ri" and os.access(RI_IN,os.F_OK) and os.access(RI_IN,os.R_OK) and os.access(RI_IN,os.W_OK)) :
		sys.stderr.write("Erreur: chemin vers fichier .ri : "+RI_IN+ " doit etre accessible en lecture et en ecriture.\n"        )
		sys.exit(1)
	#------------------
	# le second paramètre est le chemin de lecture du fichier .fcige d'entree
	if not( len(FCIGE_IN) > 6 and FCIGE_IN[-6:]==".fcige" and os.access(FCIGE_IN,os.F_OK) and os.access(FCIGE_IN,os.R_OK) and os.access(FCIGE_IN,os.W_OK)) :
		sys.stderr.write("Erreur: chemin vers fichier .fcige : "+FCIGE_IN+ " doit etre accessible en lecture et en ecriture.\n"        )
		sys.exit(1)
	#------------------
	# le dernier paramètre est le chemin d'ecriture du fichier .ri de sortie
	if not( len(FCIGE_OUT) > 6 and FCIGE_OUT[-6:]==".fcige" and (not os.access(FCIGE_OUT,os.F_OK) or os.access(FCIGE_OUT,os.W_OK ) ) ) :
		sys.stderr.write("Erreur: chemin vers fichier .fcige "+FCIGE_OUT+ " doit etre accessible en ecriture.\n")
		usage()
		sys.exit(1)
	#------------------
	# lecture des données du fichier .ri pour l'obtention du support (effectif max)
	fi = open( RI_IN, 'r')
	parser = RIParser( fi)
	ri = parser.parse()
	fi.close()
	#------------------
	# lecture des regles depuis le fichier *.fcige
	fi = open( FCIGE_IN, 'r')
	parser = FCIGEParser( fi, ri.get_items())
	rules = parser.parse()
	fi.close()
	#------------------
	# verification et ajout eventuelle de la regle.
	has_bottom = False
	emptyset= ri.get_items().binarise([])
	for pre,_ in rules.iter_premisses() :
		has_bottom =emptyset in pre
		if has_bottom : break
	if not has_bottom :
		rules.add_rule(emptyset, emptyset)
		rules.set_extension( emptyset, ri.number_of_tIDs()) 
	#------------------
	# ecriture des données 
	fo = open( FCIGE_OUT, 'w')
	fo.write("# Ajustement du contenu du fichier "+FCIGE_IN+"\n")
	fo.write("# check_add_bottom: regle nulle présete\n\n")
	fo.write(str(rules))
	fo.close()
	exit(0)
	
	





