#!/usr/bin/python
# -*- coding: utf8 -*-

from RIParser import RIParser
from FCIGEParser import FCIGEParser
from AbstractionController import LocalAbstractionController
import sys
import os
import string
import math

def usage() :
	print "\
----------------------------------------------------------------- \n\
                Abstraction d'un jeu de regles                    \n\
                                                                  \n\
Ce script permet d'executer une projection local d'un jeu de      \n\
regles et de calculer les regles abstraites.                      \n\
Le script ecrit dans un fichier :                                 \n\
                                                                  \n\
    [1] Les regles Clos/Generateurs abstraites                    \n\
                                                                  \n\
	clos_abs (support) +; [gen_abs_i, gen_abs_j, ... , gen_abs_N] \n\
                                                                  \n\
    [2] Les fusions des classes d'équivalence:                    \n\
                                                                  \n\
	clos_abs (extension) +; [cl_ori_i, cl_ori_j, ... , cl_ori_N]  \n\
                                                                  \n\
    [3] La liste des clos devenus infrequents par la              \n\
	    projection.                                               \n\
                                                                  \n\
Remarque: Les regles [1] donne la cardinalité de l'extension de   \n\
chaque clos abstrait, alors que les regles [2] donnent la liste   \n\
explicite des tIDs formant l'extension.                           \n\
                                                                  \n\
Syntaxe:                                                          \n\
                                                                  \n\
    ./abstraction.py   minsup   mindeg   mincc   mintercc   \     \n\
	                   in.ri    in.fcige out.abs                  \n\
                                                                  \n\
Avec:                                                             \n\
	[-] minsup <int> : entier correspondant au support minimal    \n\
	                   exprime en nombre de transactions.         \n\
	[-] mindeg <int> : entier correspondant au degre minimal des  \n\
	                   transactions dans le graphe pour etre      \n\
					   conservees lors de la projection.          \n\
	[-] mincc <int>  : entier correspondant a la taille minimale  \n\
	                   des composantes connexes du graphe simple  \n\
					   auxquelles doivent appartenir les          \n\
					   transactions pour etre conservees lors de  \n\
					   la projection.                             \n\
	[-] mintercc <int> : entier correspondant a la taille minimale\n\
	                   des composantes connexes du graphe des     \n\
					   triangles auxquelles doivent appartenir les\n\
					   transactions pour etre conservees lors de  \n\
					   la projection.                             \n\
	[-] in.ri <path> : le fichier ri ou sont lues les donnees de  \n\
	                   depart (relationnelles et transactionnelles\n\
	[-] in.fcige <path> : le fichier fcige ou sont lues les regles\n\
	                   a projeter.                                \n\
	[-] out.abs <path> : le fichier ou sont ecrites les donnnees  \n\
	                   de projection et les regles abstraites.    \n\
                                                                  \n\
----------------------------------------------------------------- "


if __name__ == "__main__" :
	#------------------
	# le programme prend un parametre: le nom du fichier *.ri dont il faut ajuster
	# l'ordre des attributs
	if len(sys.argv) != 8 :
		sys.stderr.write("Erreur: il manque un ou plusieurs arguments. %d arguments trouvés\n"%len(sys.argv))
		usage()
		sys.exit(1)
	#------------------
	try:
		MIN_SUPP   = int(sys.argv[1])
	except TypeError :
		sys.stderr.write("Erreur: le premier argument doit etre un entier correspondant au support minimal exprime en nombre de transactions.")
		usage()
		sys.exit(1)
	#------------------
	try:
		MIN_DEG   = int(sys.argv[2])
	except TypeError :
		sys.stderr.write("Erreur: le deuxieme argument doit etre un entier correspondant au degre minimal des transactions dans le graphe pour etre conservees lors de la projection.")
		usage()
		sys.exit(1)
	#------------------
	try:
		MIN_CC = int(sys.argv[3])
	except TypeError :
		sys.stderr.write("Erreur: le troisieme argument doit etre un entier correspondant a la taille minimale des composantes connexes du graphe simple auxquelles doivent appartenir les transactions pour etre conservees lors de la projection.")
		usage()
		sys.exit(1)
	#------------------
	try:
		MIN_TERCC = int(sys.argv[4])
	except TypeError :
		sys.stderr.write("Erreur: le quatrieme argument doit etre un entier correspondant a la taille minimale des composantes connexes du graphe des triangles auxquelles doivent appartenir les transactions pour etre conservees lors de la projection.")
		usage()
		sys.exit(1)
	#------------------
	# le paramètre est le chemin de lecture du fichier .ri d'entree
	if not( len(sys.argv[5]) > 3 and sys.argv[5][-3:]==".ri" and os.access(sys.argv[5],os.F_OK) and os.access(sys.argv[5],os.R_OK)) :
		sys.stderr.write("Erreur: chemin vers fichier .ri : "+sys.argv[5]+ " doit etre accessible en lecture.\n"        )
		usage()
		sys.exit(1)
	else:
		RI_IN = sys.argv[5]
	#------------------
	# le paramètre est le chemin de lecture du fichier .fcige d'entree
	if not( len(sys.argv[6]) > 6 and sys.argv[6][-6:]==".fcige" and os.access(sys.argv[6],os.F_OK) and os.access(sys.argv[6],os.R_OK) and os.access(sys.argv[6],os.W_OK)) :
		sys.stderr.write("Erreur: chemin vers fichier .fcige : "+sys.argv[6]+ " doit etre accessible en lecture et en ecriture.\n"        )
		usage()
		sys.exit(1)
	else:
		FCIGE_IN = sys.argv[6]
	#------------------
	# le paramètre est le chemin d'ecriture du fichier .abs de sortie
	if not( len(sys.argv[7]) > 4 and sys.argv[7][-4:]==".abs" and (not os.access(sys.argv[7],os.F_OK) or os.access(sys.argv[7],os.W_OK ) ) ) :
		sys.stderr.write("Erreur: chemin vers fichier .abs : "+sys.argv[7]+ " doit etre accessible en ecriture.\n"        )
		usage()
		sys.exit(1)
	else:
		ABS_OUT = sys.argv[7]
	#------------------
	#if ( MIN_CC != 0 or MIN_DEG != 0) and ( MIN_TERCC != 0) :
	#	sys.stderr.write("Attention vous travaillez dans deux espaces (simple et triangle). Ceci n'est pas autorise pour l'instant!")
	#	sys.exit(1)
	IN_SIMPLE = ( MIN_TERCC == 0 )
	#------------------
	# lecture des données du fichier *.ri
	fi = open( RI_IN, 'r')
	parser = RIParser( fi)
	ri = parser.parse()
	fi.close()
	#------------------
	# lecture des données du fichier *.fcige
	fi = open( FCIGE_IN, 'r')
	parser = FCIGEParser( fi, ri.get_items())
	clos_gen_ori = parser.parse()
	fi.close()
	#------------------
	# execution de la projection et calcul des abstractions
	abstractor = LocalAbstractionController( clos_gen_ori, ri, MIN_SUPP, MIN_DEG, MIN_CC, MIN_TERCC, in_simple=IN_SIMPLE, title=RI_IN)
	abstractor.abstract()
	#------------------
	# ecriture des données 
	fo = open( ABS_OUT, 'w')
	fo.write(str(abstractor))
	fo.close()
	exit(0)
	
	





