#! /usr/bin/python
# -*- coding: utf8 -*-
import networkx as nx

def common_neighbors(g,u,v) :
	nu = g.neighbors(u)
	nu.remove(v)
	nv = g.neighbors(v)
	nv.remove(u)
	return set(nu).intersection(nv)

def sortedTuple(l):
	return (tuple)(sorted((list)(l)))

def upDateToTNode(toTNode,e,tnode) :
	es = sortedTuple(e)
	if toTNode.has_key(es) :
		toTNode[es].add(tnode)
	else:
		toTNode[es]=set([tnode])

def getTNode(toTNode,e) :
	es =sortedTuple(e)
	if toTNode.has_key(es):
		return toTNode[es]
	else:
		return set([])

class GrapheDesTriangles(nx.Graph) :
	"""
	GrapheDesTriangles est le graphe de connectivite des 3-cliques d'un graphe g.
	
	[-] Les noeuds du GrapheDesTriangles correspondent aux triangles de g
	[-] Les aretes du GrapheDesTriangles lient deux noeud si les triangles
		associes a ces ddeux noeuds dans g partagent une arete commune
	"""
	def __init__(self, g, data=None,name=None,**attr):
		"""
		L'instanciation de ce graphe dérive du traitement d'un graphe simple g.
		La nouvelle instance est le graphe de connectivite des 3-clique de g.
		"""
		nx.Graph.__init__(self, data=data,name=name,**attr)	
		edgeToTNode= dict()
		for u,v in g.edges() :
			for n in common_neighbors(g,u,v) :
				tnew = sortedTuple([u,v,n])
				self.add_node(tnew)
				for e in [(u,v),(n,v),(u,n)]:
					try :
						for t in edgeToTNode[sortedTuple(e)] :
							if t != tnew :
								self.add_edge(t,tnew)
					except KeyError :
						pass
					upDateToTNode(edgeToTNode,e,tnew)
		edgeToTNode = None
	
	def nodes_in_cc_of_size_at_least(self, mincctersize):
		nodeset = set([])
		for cc in nx.connected_components(self):
			# les noeuds des 3-cliques
			nodes=set().union(*cc)
			# la taille de la cc (nombre de noeuds simples)
			l = len(nodes)
			if l < mincctersize :
				continue
			# attention un noeuds peut appartenir a deux (ou plus) 3-cliques
			# faisant partie de cc différentes
			for n in nodes :
				nodeset.add(n)
		return nodeset

	def max_cc_size(self, mincctersize) :
		"""
		Renvoie un dictionnaire dont
			[une clef] est un noeud (simple) constituant les 3-cliques qui eux
			forment les somments du graphe des triangles
			[une valeur] est la taille de la plus grande cc du graphe des 3-clique
			La taille d'une composante connexe est ici calculée comme le nombre
			de sommets simples composant les noeuds du graphe des 3-ciques et non
			le nombre de sommet du graphe des 3-cliques.
			
			Seuls les noeuds simples  qui appartiennent à une cc du graphe des
			3-cliques dont la taille (au sens donné supra) est supérieur à
			mincctersize sont des clefs du dictionnaire.
		"""
		sNodeToTerCCMaxSize=dict()
		for cc in nx.connected_components(self):
			# les noeuds des 3-cliques
			nodes=set().union(*cc)
			# la taille de la cc (nombre de noeuds simples)
			l = len(nodes)
			if l < mincctersize :
				continue
			# attention un noeuds peut appartenir a deux (ou plus) 3-cliques
			# faisant partie de cc différentes
			for n in nodes :
				try :
					if l > sNodeToTerCCMaxSize[n]:
						sNodeToTerCCMaxSize[n] = l
				except KeyError :
					sNodeToTerCCMaxSize[n]=l
		return sNodeToTerCCMaxSize
	
#	def subgraphFromSimpleNodes(self, listeObjets ) :
		


if __name__ == '__main__' :
	TEST_OK = True
	#import os
	#from ProjClos import *
	#import sys
	#ri = RIReader()
	#g = ri.readRI(os.path.join("./data/","all.ri"),True).graph
	#g = ri.readRI(os.path.join("./data/","mougel.ri"),True).graph
	
    #                     |
	# g =  1              |     g3 = 
    #                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_node(1)
	g3=nx.Graph()
    
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:0}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
    #                     |
	# g =  1--2           |     g3 = 
    #                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edge(1,2)
	g3=nx.Graph()
    
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:0,2:0}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
    #                     |
    #        2            |
	# g =   /             |     g3 = 
    #      1--3           |
    #                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(1,3)])
	g3=nx.Graph()
    
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:0, 2:0, 3:0}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
    #                     |
    #        2            |
	# g =   / \           |     g3 = (123)
    #      1--3           |
    #                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(1,3),(2,3)])
	g3=nx.Graph()
	g3.add_node((1,2,3))
    
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:3, 2:3, 3:3}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# -----------------------------------------------------------------
    #                     |
	#        2--4--6      |
	# g =   / \/ \ /      |     g3 = (123)--(234)--(345)--(456)
    #      1--3--5        |
    #                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(3,5),(4,5),(4,6),(5,6)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(2,3,4)],[(2,3,4),(3,4,5)],[(3,4,5),(4,5,6)]])
    
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:6, 2:6, 3:6, 4:6, 5:6, 6:6}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#     2---3           |
	#     |\ /|           |           (123)---(134)
	# g = | 1 |           |    g3 =     |       |
	#     |/ \|           |           (152)---(145)
	#     5---4           |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(1,4),(3,4),(1,5),(4,5),(2,5)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(1,3,4)],[(1,3,4),(1,4,5)],[(1,4,5),(1,2,5)],[(1,2,5),(1,2,3)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:5, 2:5, 3:5, 4:5, 5:5}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#               7--8  |
	#              / \/   |          (123)       (567)
	# g =   2--4--5--6    |  g3 =      |           |
	#      / \/           |          (234)       (678)
	#     1--3            |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(4,5),(5,6),(5,7),(6,7),(6,8),(7,8)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(2,3,4)],[(5,6,7),(6,7,8)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:4, 2:4, 3:4, 4:4, 5:4, 6:4, 7:4, 8:4}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#               7--8  |
	#              / \/   |          (123)       (567)---(569)
	# g =   2--4--5--6    |  g3 =      |           |
	#      / \/   \ /     |          (234)       (678)
	#     1--3     9      |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(4,5),(5,6),(5,7),(6,7),(6,8),(7,8),(5,9),(6,9)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(2,3,4)],[(5,6,7),(6,7,8)],[(5,6,7),(5,6,9)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:4, 2:4, 3:4, 4:4, 5:5, 6:5, 7:5, 8:5, 9:5}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#            6--7     |
	#           / \/      |          (123)       (456)
	# g =   2--4--5       |  g3 =      |           |
	#      / \/           |          (234)       (567)
	#     1--3            |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(4,5),(4,6),(5,6),(5,7),(6,7)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(2,3,4)],[(4,5,6),(5,6,7)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:4, 2:4, 3:4, 4:4, 5:4, 6:4, 7:4, 8:4}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#            6--7     |
	#           / \/      |          (123)       (456)
	# g =   2--4--5       |  g3 =      |           |
	#      / \/  /        |          (234)       (567)
	#     1--3  /         |
	#     |____/          |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(4,5),(4,6),(5,6),(5,7),(6,7),(1,5)])
	g3=nx.Graph()
	g3.add_edges_from([[(1,2,3),(2,3,4)],[(4,5,6),(5,6,7)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:4, 2:4, 3:4, 4:4, 5:4, 6:4, 7:4}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	#            6        |
	#           / \       |          (123)       
	# g =   2--4--5       |  g3 =      |         (456)
	#      / \/           |          (234)       
	#     1--3            |
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(2,3),(1,3),(2,4),(3,4),(4,5),(4,6),(5,6)])
	g3=nx.Graph()
	g3.add_node((4,5,6))
	g3.add_edges_from([[(1,2,3),(2,3,4)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )
	
	dico = {1:4, 2:4, 3:4, 4:4, 5:3, 6:3}
	for k,v in GrapheDesTriangles(g).max_cc_size(0).iteritems() :
		TEST_OK &= (dico[k] == v)
	# --------------------------------------------------------------------
	#                     |
	# g =   K(5)          |  g3 =  isomorphe a K(10)
	#                     |
	# --------------------------------------------------------------------
	g = nx.Graph()
	g.add_edges_from([(1,2),(1,3),(1,4),(1,5),(2,3),(2,4),(2,5),(3,4),(3,5),(4,5)])
	g3=nx.Graph()
	#g3.add_nodes_from([(1,2,3),(1,2,4),(1,2,5),(1,3,4),(1,3,5),(1,4,5),(2,3,4),(2,3,5),(2,4,5),(3,4,5)])
	g3.add_edges_from([[(1,2,3),(1,2,4)],[(1,2,3),(1,2,5)],[(1,2,3),(1,3,4)],[(1,2,3),(1,3,5)],[(1,2,3),(2,3,4)],[(1,2,3),(2,3,5)],[(1,2,4),(1,2,5)],[(1,2,4),(1,3,4)],[(1,2,4),(1,4,5)],[(1,2,4),(2,3,4)],[(1,2,4),(2,4,5)],[(1,2,5),(1,3,5)],[(1,2,5),(1,4,5)],[(1,2,5),(2,3,5)],[(1,2,5),(2,4,5)],[(1,3,4),(1,3,5)],[(1,3,4),(1,4,5)],[(1,3,4),(2,3,4)],[(1,3,4),(3,4,5)],[(1,3,5),(1,4,5)],[(1,3,5),(2,3,5)],[(1,3,5),(3,4,5)],[(1,4,5),(2,4,5)],[(1,4,5),(3,4,5)],[(2,3,4),(2,3,5)],[(2,3,4),(2,4,5)],[(2,3,4),(3,4,5)],[(2,3,5),(2,4,5)],[(2,3,5),(3,4,5)],[(2,4,5),(3,4,5)]])
	
	TEST_OK &=  ( sorted(map(lambda e: sorted(e), GrapheDesTriangles(g).edges())) == 
                  sorted(map(lambda e: sorted(e),g3.edges()))                        and
                  sorted(GrapheDesTriangles(g).nodes()) ==
                  sorted(g3.nodes())     )

	# --------------------------------------------------------------------
	import RIParser
	import string
	#fi = open("data/mougel.ri", 'r')
	fi = open("data/s50Traf4.ri", 'r')
	parser = RIParser.RIParser(fi)
	g = parser.parse().get_graph()
	fi.close()
	gTer = GrapheDesTriangles(g)
	print len(gTer.nodes())
	print string.join(map(lambda e: str(e), gTer.nodes()),'\n')
	print
	print len(gTer.edges())
	print string.join(map(lambda e: str(e), gTer.edges()),'\n')

	# --------------------------------------------------------------------
	
	if TEST_OK :
		print "Tests OK"
	else :
		print "Tests Echec"
