# -*- coding: utf8 -*-
from Itemset import Items
from ItemsetRules import ItemsetRules
import re

REGEX_ITEM   = r"\{\s*(?:[\w\-@]+)?(?:\s*,\s*(?:[\w\-@]+))*\s?\}"
REGEX_EXT    = r"\(.*\)"
REGEX_PREM   = r"\[\s*(?:"+REGEX_ITEM+r"+)?(?:\s*,\s*(?:"+REGEX_ITEM+r"+))*\s?\]"
REGEX_RULE   = r"^\s*("+REGEX_ITEM+r")\s*("+REGEX_EXT+r")\s*\+;\s*("+REGEX_PREM+r")\s*$"


class FCIGEParserException(Exception) :
	def __init__(self, value):
		self.value = value
	def __str__(self):
		return repr(self.value)

class FCIGEParser :
	def __init__(self, fi, items) :
		"""
		Le constructeur prend la reference d'un Items en parametre (cela fixe le codage et une
		description explicite ou codée sous forme d'entier de l'itemset.
		"""
		if not isinstance( items, Items) :
			raise FCIGEParserException( "%s doit être de type Items\n"%str(items))
		self._rules = ItemsetRules( items )
		self._f = fi
		self._cur_rule = None
	
	def _is_eof( self) :
		return -1 == self._cur_rule

	def _next_rule(self) :
		while True :
			li = self._f.readline()
			if ''  == li :
				self._cur_rule = -1
				return
			m = re.match( REGEX_RULE, li)
			if None != m :
				self._cur_rule = m.group(1,2,3)
				return

	def _parse_concl(self) :
		return self._rules.get_items().binarise(re.findall( r"[\w\-@]+", self._cur_rule[0]))

	def _parse_ext(self) :
		return re.findall(r"\d+",self._cur_rule[1])[0]

	def _parse_prem(self) :
		return [ self._rules.get_items().binarise(re.findall( r"[\w\-@]+", it)) for it in re.findall( REGEX_ITEM,self._cur_rule[2])]

	def parse(self) :
		while True :
			self._next_rule()
			if self._is_eof() : return self._rules
			concl = self._parse_concl()
			premisses = self._parse_prem()
			ext = self._parse_ext()
			self._rules.add_rule(concl, *premisses)
			self._rules.set_extension(concl, ext)
			
		
#-------------------------------------------------------------------------------
if __name__ == '__main__' :
	items = Items( ["blues", "folk", "jazz", "pop", "rock"] )
	fi = open( 'data/mougel_25.fcige', 'r')
	parser = FCIGEParser( fi, items)
	clos_gen = parser.parse()
	fi.close()
	print clos_gen
	

			

